/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.util.ResourceLocation;

public class FolderResourceIndex
extends ResourceIndex {
    private final File field_188548_a;

    public FolderResourceIndex(File file) {
        this.field_188548_a = file;
    }

    @Override
    public File func_188547_a(ResourceLocation resourceLocation) {
        return new File(this.field_188548_a, resourceLocation.toString().replace(':', '/'));
    }

    @Override
    public File func_225638_a_(String string) {
        return new File(this.field_188548_a, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ResourceLocation> func_225639_a_(String string, String string2, int n, Predicate<String> predicate) {
        Path path3 = this.field_188548_a.toPath().resolve(string2);
        try (Stream<Path> \u260322222 = Files.walk(path3.resolve(string), n, new FileVisitOption[0]);){
            Collection collection = \u260322222.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> !path.endsWith(".mcmeta")).filter(path -> predicate.test(path.getFileName().toString())).map(path2 -> new ResourceLocation(string2, path3.relativize((Path)path2).toString().replaceAll("\\\\", "/"))).collect(Collectors.toList());
            return collection;
        }
        catch (NoSuchFileException \u260322222) {
            return Collections.emptyList();
        }
        catch (IOException iOException) {
            field_152783_a.warn("Unable to getFiles on {}", (Object)string, (Object)iOException);
        }
        return Collections.emptyList();
    }
}

